/**
 * Solution to: NahkAcademy
 * ---------------------------
 * This is the reference solution for problem 3 of
 * the Winter 2018 midterm. It is meant to test how
 * well students understand variables and control flow. 
 * This problem is perhaps easier without decomposition!
 * By Christopher James Piech.
 */
import acm.program.*;
import acm.util.*;

public class NahkAcademy extends ConsoleProgram {

  private RandomGenerator rg = new RandomGenerator();

  public void run() {
    // keep track of how many correct in-a-row
    int nCorrect = 0;
    
    // loop as long as correct in-a-row is less than 3
    while(nCorrect < 3) {
      // generate a random question
      int a = rg.nextInt(1, 10);
      int b = rg.nextInt(1, 10);
      int soln = a + b;
      
      // have the user solve the question
      int guess = readInt("What is " + a + " + " + b +"? ");
      
      // update state based on their answer
      if(guess == soln) {
        nCorrect++;
        println("Good job!");
      } else {
        nCorrect = 0;
        println("The correct is: " + soln);
      }
    }
    
    // if you are out of the loop, correct-in-a-row == 3
    println("You have mastered basic addition!");
  }
}